/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.util.ArrayList;
import java.util.List;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.visitor.AllAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.annotation.visitor.MultiAnnotationVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.gson.OptimizedJsonInfo;

public class OptimizedJsonFieldCollector
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor {
    private final OptimizedJsonInfo optimizedJsonInfo;
    private final Mode mode;
    private OptimizedJsonInfo.ClassJsonInfo classJsonInfo;

    public OptimizedJsonFieldCollector(OptimizedJsonInfo optimizedJsonInfo, Mode mode) {
        this.optimizedJsonInfo = optimizedJsonInfo;
        this.mode = mode;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.classJsonInfo = new OptimizedJsonInfo.ClassJsonInfo();
        this.optimizedJsonInfo.classJsonInfos.put(programClass.getName(), this.classJsonInfo);
        this.optimizedJsonInfo.classIndices.put(programClass.getName(), null);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        OptimizedJsonInfo.ClassJsonInfo classJsonInfo = this.optimizedJsonInfo.classJsonInfos.get(programClass.getName());
        programField.attributesAccept(programClass, new AllAnnotationVisitor(new MultiAnnotationVisitor(new AnnotationTypeFilter("Lcom/google/gson/annotations/SerializedName;", (AnnotationVisitor)new SerializedNamesCollector(classJsonInfo)), new AnnotationTypeFilter("Lcom/google/gson/annotations/Expose;", (AnnotationVisitor)new ExposedFieldsCollector(classJsonInfo, this.mode)))));
        String fieldName = programField.getName(programClass);
        if (classJsonInfo.javaToJsonFieldNames.get(fieldName) == null) {
            classJsonInfo.javaToJsonFieldNames.put(fieldName, new String[]{fieldName});
            this.optimizedJsonInfo.jsonFieldIndices.put(fieldName, null);
        } else {
            for (String jsonFieldName : classJsonInfo.javaToJsonFieldNames.get(fieldName)) {
                this.optimizedJsonInfo.jsonFieldIndices.put(jsonFieldName, null);
            }
        }
    }

    public static enum Mode {
        serialize,
        deserialize;

    }

    private static class SerializedNamesCollector
    extends SimplifiedVisitor
    implements AnnotationVisitor,
    ElementValueVisitor {
        private final OptimizedJsonInfo.ClassJsonInfo classJsonInfo;
        private List<String> currentJsonFieldNames;

        public SerializedNamesCollector(OptimizedJsonInfo.ClassJsonInfo classJsonInfo) {
            this.classJsonInfo = classJsonInfo;
        }

        @Override
        public void visitAnnotation(Clazz clazz, Annotation annotation) {
        }

        @Override
        public void visitAnnotation(Clazz clazz, Field field, Annotation annotation) {
            this.currentJsonFieldNames = new ArrayList<String>();
            annotation.elementValuesAccept(clazz, this);
            String[] jsonNamesArray = this.currentJsonFieldNames.toArray(new String[0]);
            this.classJsonInfo.javaToJsonFieldNames.put(field.getName(clazz), jsonNamesArray);
        }

        @Override
        public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
        }

        @Override
        public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
            this.currentJsonFieldNames.add(clazz.getString(constantElementValue.u2constantValueIndex));
        }

        @Override
        public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
            arrayElementValue.elementValuesAccept(clazz, annotation, this);
        }
    }

    private static class ExposedFieldsCollector
    extends SimplifiedVisitor
    implements AnnotationVisitor,
    ElementValueVisitor,
    ConstantVisitor {
        private final OptimizedJsonInfo.ClassJsonInfo classJsonInfo;
        private final Mode mode;
        public boolean exposeCurrentField;

        public ExposedFieldsCollector(OptimizedJsonInfo.ClassJsonInfo classJsonInfo, Mode mode) {
            this.classJsonInfo = classJsonInfo;
            this.mode = mode;
        }

        @Override
        public void visitAnnotation(Clazz clazz, Annotation annotation) {
        }

        @Override
        public void visitAnnotation(Clazz clazz, Field field, Annotation annotation) {
            this.exposeCurrentField = true;
            annotation.elementValuesAccept(clazz, this);
            if (this.exposeCurrentField) {
                this.classJsonInfo.exposedJavaFieldNames.add(field.getName(clazz));
            }
        }

        @Override
        public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
        }

        @Override
        public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
            if (constantElementValue.getMethodName(clazz).equals(this.mode.toString())) {
                clazz.constantPoolEntryAccept(constantElementValue.u2constantValueIndex, this);
            }
        }

        @Override
        public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
            if (integerConstant.u4value == 0) {
                this.exposeCurrentField = false;
            }
        }
    }
}

