import lookup from 'country-code-lookup';
const countryAliases = {
    'Czech Republic': 'Czechia',
    'Korea, Republic of': 'South Korea'
};
function resolveCountry(name) {
    const lookupName = name in countryAliases ? countryAliases[name] : name;
    const c = lookup.byCountry(lookupName);
    if (c && c.continent === 'Americas') {
        c.continent = c.region;
    }
    return c;
}
export default resolveCountry;
export { resolveCountry };
//# sourceMappingURL=resolveCountry.js.map