# artix-mlg

CLI to create an pacman mirrorlist and archweb fixture file from the Artix mirrorlist.

## Setup

```
npm install
```

Create an input file `mirrors.json` with all mirrors according to the spec.

## The Spec

artix-mlg expects the input file to contain an array `"mirrors"` of objects following this schema:

```
interface MirrorProfile {
    url: string;               // The full pacman mirror url, e.g. https://mirror.example.com/artix-linux/$repo/os/$arch
    tier: number;              // https://wiki.archlinux.org/title/DeveloperWiki:NewMirrors#2-tier_mirroring_scheme
    country: string;           // Country name
    public: boolean;           // Whether the mirror is meant for users
    active: boolean;           // Whether the mirror is currently in service
    default: boolean;          // Whether the mirror is considered a default mirror
    admin_email?: string;      // (optional) Email address of the mirror administrator
    alternate_email?: string;  // (optional) Alternate email address for the mirror administrator
    isos?: boolean;            // (optional) Whether the mirror hosts ISOs (automatically determined by artix-mlg)
    rsync_user?: string;       // (optional) rsync username, if applicable
    rsync_password?: string;   // (optional) rsync password, if applicable
    notes?: string;            // (optional) notes to be stored in archweb
}
```

## Run

```
npm run start
```

Then add to archweb like so:

```
manage.py loaddata files/mirrors.fixture.json
```
